<?php
  $stat_file = "./stats.txt";
  function writeData($stat_file, $ile)
  {
    $file_str = "";
    if(file_exists($stat_file)){
      if(($arr = file($stat_file)) === false){
        //Błąd przy próbie odczytu zawartości pliku
        return false;
      }
    }
    if(!$fd = fopen($stat_file, "w")){
      //Błąd przy próbie otwarcia pliku
      return false;
    }
    $str = date("Y-m-d G:i")." ";
    $str .= $_SERVER['REMOTE_ADDR']." ";
    if(isset($_SERVER['HTTP_USER_AGENT'])){
      $str .= $_SERVER['HTTP_USER_AGENT'];
    }
    $str .= "\n";
    array_unshift($arr, $str);
    $count = count($arr);
    for($i = 0; $i < $count && $i < $ile; $i++){
      fwrite($fd, $arr[$i]);
    }
    fclose($fd);
    return true;
  }

  function printData($stat_file)
  {
    if(!$fd = fopen($stat_file, "r")){
      //Błąd przy próbie otwarcia pliku
      return false;
    }
    echo "<ol>";
    while (!feof($fd)){
      if(($str = fgets($fd)) != "")
        echo("<li>$str</li>");
    }
    echo "</ol>";
    return true;
  }
  
  writeData($stat_file, 10);
?>

<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Moja strona WWW</title>
  </head>
  <body>
    <p>Lista odwiedzin:</p>
    <div>
    <?php
      if(!printData($stat_file)){
        echo("<p>Lista nie jest w tej chwili dostępna.</p>");
      }
    ?>
    </div>
  </body>
</html>
